#include <amxmodx>

#define PLUGIN "Admin Login System"
#define VERSION "1.2.1"
#define AUTHOR "mforce"

new const PREFIX[] = "AdminSystem"

// HA SQL-t szeretnél használni, vedd ki a # elől a //-t és írd be az adatokat lentebb. (alapból fájlba ment)
//#define SQL

#if defined SQL
	#include <sqlx>
	new Handle:g_SqlTuple;
	
	new const SQL_INFO[][] = {
		"127.0.0.1",	// HOST
		"USERNAME",		// USERNAME
		"PASSWORD",		// PASSWORD
		"DATABASE"		// DATABASE
	}
#endif

enum _:admininfo
{
	steamidchk[32],
	passwordchk[32],
	flagschk[32]
}

new Array:adminlist
new data[admininfo];
new password[33][32], flags[33][32], writepass[33][32], bool:loggedin[33], bool:admins[33];

public plugin_init() {
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_clcmd("say /login", "admin_menu")
	register_clcmd("say /admintoltes", "loadadmins")
	register_clcmd("JELSZO", "Jelszo")
	register_cvar("admin_login_system", AUTHOR, FCVAR_SERVER | FCVAR_SPONLY);
	set_task(60.0, "admincheck", .flags = "b");
	
	adminlist = ArrayCreate(admininfo)
}

public admincheck() {
	new players[32], num;
	get_players(players, num, "ch")
	for(new i = 0; i < num; i++) {
		new tempid = players[i]
		if(admins[tempid] && !loggedin[tempid]) {
			ChatColor(tempid, "^4[%s]^1 Az admin bejelentkezéshez írd be: ^3/login", PREFIX)
		}
	}
}

public client_putinserver(id) {
	if(!is_user_bot(id) && !is_user_hltv(id)) {
		new steamid[32]; get_user_authid(id, steamid, charsmax(steamid));
		if(containi(steamid, "_ID_LAN") != -1) return;

		for(new i = 0; i < ArraySize(adminlist); i++) {
			ArrayGetArray(adminlist, i, data)
		
			if(equal(steamid, data[steamidchk])) {
				copy(password[id], charsmax(password[]), data[passwordchk])
				copy(flags[id], charsmax(flags[]), data[flagschk])
				admins[id] = true;
				set_task(10.0, "admin_menu", id);
			}
		}
	}
}

public loadadmins(id) {
	if(get_user_flags(id) & ADMIN_RCON) {
		ArrayClear(adminlist)
		ChatColor(id, "^4[%s]^1 Adminok újra betöltve.", PREFIX)
		load()
	}
	else ChatColor(id, "^4[%s]^1 Nincs jogod a parancs használatához.", PREFIX)
}

public client_disconnect(id) {
	loggedin[id] = false;
	admins[id] = false;
	copy(password[id], charsmax(password), "")
	copy(writepass[id], charsmax(writepass), "")
	copy(flags[id], charsmax(flags), "")
	if(task_exists(id)) remove_task(id);
}

public admin_menu(id) {
	if(!admins[id]) {
		ChatColor(id, "^4[%s]^1 Nincs jogod az admin belépéshez, mert nem szerepelsz adatbázisban.", PREFIX)
		return PLUGIN_HANDLED;
	}
	
	new temp[128];
	formatex(temp, charsmax(temp), "\r[\y%s\r] \wAdmin Login System ^nby \y%s", PREFIX, AUTHOR)
	new menu = menu_create(temp, "admin_menu_h" )
	if(!loggedin[id]) {
		new steamid[32]; get_user_authid(id, steamid, charsmax(steamid));
		formatex(temp, charsmax(temp), "\rSteamID: \d%s", steamid)
		menu_additem(menu,temp, "0",0)
		formatex(temp, charsmax(temp), "\rJelszó: \d%s^n", writepass[id])
		menu_additem(menu,temp, "1",0)
	}
	else {
		menu_additem(menu,"\r[\wStátusz\r]: \yBejelentkezve","0",0)
		formatex(temp, charsmax(temp), "\rJogok:\d %s^n", flags[id])
		menu_additem(menu,temp, "1",0)
	}
	formatex(temp, charsmax(temp), "%s", loggedin[id] ? "Kijelentkezés":"Bejelentkezés")
	menu_additem(menu, temp, "2",0)
	
	menu_setprop(menu, MPROP_EXIT, MEXIT_ALL);
	menu_setprop(menu, MPROP_EXITNAME, "Kilépés");
	menu_display(id, menu, 0)
	return PLUGIN_HANDLED;
}

public admin_menu_h(id, menu, item) {
	if(item == MENU_EXIT) {
		menu_destroy(menu);
		return PLUGIN_HANDLED;
	}
	new command[6], name[64], access, callback;
	menu_item_getinfo(menu, item, access, command, sizeof command - 1, name, sizeof name - 1, callback);

	switch(item)
	{
		case 0: {
			admin_menu(id)
		}
		case 1: {
			if(!loggedin[id]) {
				client_cmd(id, "messagemode JELSZO")
			}
			else admin_menu(id)
		}
		case 2: {
			if(!loggedin[id]) {
				if(strlen(password[id]) >= 6 && equal(writepass[id], password[id]) && !equal(flags[id],"")) {
					ChatColor(id, "^4[%s]^1 Sikeresen beléptél! Admin információk: ^3/login", PREFIX)
					remove_user_flags(id, read_flags("z"));
					set_user_flags(id, read_flags(flags[id]));
					loggedin[id] = true;
				}
				else if(strlen(writepass[id]) == 0) {
					ChatColor(id, "^4[%s]^1 Be kell írnod a jelszót!", PREFIX)
					admin_menu(id)
				}
				else {
					ChatColor(id, "^4[%s]^1 Hibás jelszó, próbáld újra!", PREFIX)
					admin_menu(id)
				}
				copy(writepass[id], charsmax(writepass[]), "");
			}
			else {
				loggedin[id] = false;
				remove_user_flags(id, read_flags(flags[id]));
				set_user_flags(id, read_flags("z"));
				ChatColor(id, "^4[%s]^1 Sikeresen kiléptél! A belépéshez: ^3/login", PREFIX)
			}
		}
	}
	
	menu_destroy(menu);
	return PLUGIN_HANDLED;
}

public Jelszo(id) {
	new adat[32]
	read_args(adat, charsmax(adat))
	remove_quotes(adat)
	if(strlen(adat) < 6) {
		ChatColor(id, "^4[%s]^1 A jelszavadnak legalább 6 karakternek kell lennie!", PREFIX)
		copy(writepass[id], charsmax(writepass[]), "");
	}
	else {
		copy(writepass[id], charsmax(writepass[]), adat)
	}
	admin_menu(id)
}

public plugin_natives() {
	register_native("in_admin_system", "native_admins", 1);
}
public native_admins(index) {
	return admins[index];
}

stock ChatColor(const id, const szMessage[], any:...) {
	static pnum, players[32], szMsg[190], IdMsg; 
	vformat(szMsg, charsmax(szMsg), szMessage, 3);
	
	if(!IdMsg) IdMsg = get_user_msgid("SayText");
	
	if(id) {
		if(!is_user_connected(id)) return;
		players[0] = id;
		pnum = 1; 
	} 
	else get_players(players, pnum, "ch");
	
	for(new i; i < pnum; i++) {
		message_begin(MSG_ONE, IdMsg, .player = players[i]);
		write_byte(players[i]);
		write_string(szMsg);
		message_end();
	}
}

#if defined SQL
public plugin_cfg() {
	new Query[512];
	g_SqlTuple = SQL_MakeDbTuple(SQL_INFO[0],SQL_INFO[1],SQL_INFO[2],SQL_INFO[3])
	formatex(Query, charsmax(Query), "CREATE TABLE IF NOT EXISTS admin_system (`steamid` varchar(32) NOT NULL,`password` varchar(32) NOT NULL,`flags` varchar(32) NOT NULL,`id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY)")
	SQL_ThreadQuery(g_SqlTuple,"createTableThread", Query)
	load()
}

public createTableThread(FailState, Handle:Query, Error[], Errcode, Data[], DataSize, Float:Queuetime) {
	if(FailState == TQUERY_CONNECT_FAILED)
		set_fail_state("Nem tudtam csatlakozni az adatbazishoz.");
	else if(FailState == TQUERY_QUERY_FAILED)
		set_fail_state("Query Error");
	if(Errcode)
		log_amx("Hibat dobtam: %s",Error);
}

public load() {
	new Query[512];
	formatex(Query, charsmax(Query), "SELECT * FROM `admin_system`;")
	SQL_ThreadQuery(g_SqlTuple, "QuerySelectData", Query)
}

public QuerySelectData(FailState, Handle:Query, Error[], Errcode, Data[], DataSize, Float:Queuetime) { 
	if(FailState == TQUERY_CONNECT_FAILED || FailState == TQUERY_QUERY_FAILED) {
		log_amx("%s", Error)
		return
	}
	else {
		while(SQL_MoreResults(Query)) {
			SQL_ReadResult(Query, SQL_FieldNameToNum(Query, "steamid"), data[steamidchk], charsmax(data[steamidchk]));
			SQL_ReadResult(Query, SQL_FieldNameToNum(Query, "password"), data[passwordchk], charsmax(data[passwordchk]));
			SQL_ReadResult(Query, SQL_FieldNameToNum(Query, "flags"), data[flagschk], charsmax(data[flagschk]));
			ArrayPushArray(adminlist, data)
			SQL_NextRow(Query)
		}
	}
}

public plugin_end() {
	SQL_FreeHandle(g_SqlTuple)
	ArrayDestroy(adminlist)
}

#else

public plugin_cfg() {
	load()
}

public load() {
	new sBuffer[256], sFile[64], pFile;
	new sData[3][32]
 
	get_localinfo("amxx_configsdir", sFile, charsmax(sFile));
	format(sFile, charsmax(sFile), "%s/admin_system.ini", sFile);
 
	pFile = fopen(sFile, "rt");
	
	if(pFile)
	{		
		while(!feof(pFile))
		{
			fgets(pFile, sBuffer, charsmax(sBuffer));
			trim(sBuffer);
			if(sBuffer[0] == ';') continue;

			parse(sBuffer, sData[0], 31, sData[1], 31, sData[2], 31);
			
			copy(data[steamidchk], charsmax(data[steamidchk]), sData[0])
			copy(data[passwordchk], charsmax(data[passwordchk]), sData[1])
			copy(data[flagschk], charsmax(data[flagschk]), sData[2])
			ArrayPushArray(adminlist, data)
		}
		
		fclose(pFile);
	}
	else
		write_file(sFile, ";^"STEAM_0:0:12345678^" ^"jelszo582^" ^"abcdefghijklmnopqrstu^"");
}

public plugin_end() {
	ArrayDestroy(adminlist)
}
#endif